#!/usr/bin/python
# coding: UTF-8
# Rec10 TS Recording Tools
# Copyright (C) 2009-2010 Yukikaze

import os
import os.path
import optparse
import sys

import configreader
import recdblist
import auto_move
import guess
recordedpath=unicode(configreader.getpath("recorded"),'utf-8')
recpath=unicode(configreader.getpath("recpath"),'utf-8')

if __name__ == "__main__":
    usage="usage: %prog read -h"
    version="%prog 0.9.4"
    parser=optparse.OptionParser(usage=usage,version=version)
    parser.add_option("-s","--search",action="store",type="string",dest="ltitle",default="",metavar="TITLE",help="test to search where the title should be contained(test for -e)")
    parser.add_option("-A","--Auto",action="store_true",dest="auto",default=False,help="auto classifying mode(not a test)")
    parser.add_option("-e","--exec",action="store",type="string",dest="etitle",default="",metavar="TITLE",help="exec move(not a test)")
    parser.add_option("-l","--list",action="store_true",dest="list",default=False,help="File listing mode(test for -A)")
    parser.add_option("-t","--tssearch",action="store_true",dest="tssearch",default=False,help="Ts move auto search")
    parser.add_option("-T","--Tsmove",action="store_true",dest="tsmove",default=False,help="Ts auto move.")
    (opts,args)=parser.parse_args(sys.argv)
    if opts.ltitle!="":
        ltitle=unicode(opts.ltitle,'utf-8')
        sf=guess.searchFolder(ltitle, recordedpath)
        print "###MKV###"
        recdblist.printutf8(os.path.join(sf, auto_move.get_move_dest_path(ltitle,recpath,sf,".mkv")+".mkv"))
        print "###MP4###"
        recdblist.printutf8(os.path.join(sf, auto_move.get_move_dest_path(ltitle,recpath,sf,".mp4")+".mp4"))
    elif opts.auto:
        sa=auto_move.search_file(recpath, recordedpath, ".mkv")
        for t in sa:
            recdblist.printutf8(u"自動推測実行中-MKV")
            sf=guess.searchFolder(t,recordedpath)
            if sf!="":
                recdblist.printutf8(u"移動先")
                recdblist.printutf8(t+" : "+os.path.join(sf, auto_move.get_move_dest_path(t, recpath,sf,".mkv")+".mkv"))
                recdblist.printutf8(u"実行中")
                auto_move.execMove(t, recpath, recordedpath,".mkv",1)
            else:
                recdblist.printutf8(t+" can't find matching folder")
        sa=auto_move.search_file(recpath, recordedpath, ".mp4")
        for t in sa:
            recdblist.printutf8(u"自動推測実行中-MP4")
            sf=guess.searchFolder(t,recordedpath)
            if sf!="":
                recdblist.printutf8(u"移動先")
                recdblist.printutf8(t+" : "+os.path.join(sf, auto_move.get_move_dest_path(t, recpath,sf,".mp4")+".mp4"))
                recdblist.printutf8(u"実行中")
                auto_move.execMove(t, recpath, recordedpath,".mp4",1)
            else:
                recdblist.printutf8(t+" can't find matching folder")
    elif opts.list:
        sa=auto_move.search_file(recpath, recordedpath,".mkv")
        for t in sa:
            sf=guess.searchFolder(t,recordedpath)
            if sf!="":
                recdblist.printutf8(t+u" : "+os.path.join(sf, auto_move.get_move_dest_path(t, recpath,sf,".mkv")+".mkv"))
        sa=auto_move.search_file(recpath, recordedpath,".mp4")
        for t in sa:
            sf=guess.searchFolder(t,recordedpath)
            if sf!="":
                recdblist.printutf8(t+u" : "+os.path.join(sf, auto_move.get_move_dest_path(t, recpath,sf,".mp4")+".mp4"))
    elif opts.etitle!="":
        if os.path.exists(os.path.join(recpath, etitle+".mkv")):
            auto_move.execMove(etitle,recpath, recordedpath,".mkv",1)
        elif os.path.exists(os.path.join(recpath, etitle+".mp4")):
            auto_move.execMove(etitle,recpath, recordedpath,".mp4",1)
    elif opts.tssearch:
        tsmovepath=""
        try:
            tsmovepath=unicode(configreader.getpath("ts_movepath"),'utf-8')
        except:
            ""
        if tsmovepath!="":
            sa=auto_move.search_file(recpath, tsmovepath,".ts")
            for t in sa:
                sf=guess.searchFolder(t,tsmovepath,700)
                if sf!="":
                    recdblist.printutf8(t+u" : "+os.path.join(sf, auto_move.get_move_dest_path(t, recpath,sf,".ts")+".ts"))
            sa=auto_move.search_file(recpath, tsmovepath,".ts")
        else:
            recdblist.printutf8(u"ts_movepathが設定されていません。/etc/rec10.confを設定してください。")
    elif opts.tsmove:
        tsmovepath=""
        try:
            tsmovepath=unicode(configreader.getpath("ts_movepath"),'utf-8')
        except:
            ""
        if tsmovepath!="":
            sa=auto_move.search_file(recpath, tsmovepath,".ts")
            for t in sa:
                sf=guess.searchFolder(t,tsmovepath,700)
                if sf!="":
                    recdblist.printutf8(u"移動先")
                    recdblist.printutf8(t+" : "+os.path.join(sf, auto_move.get_move_dest_path(t, recpath,sf,".ts")+".ts"))
                    recdblist.printutf8(u"実行中")
                    auto_move.execMove(t, recpath, tsmovepath,".ts",0)
            sa=auto_move.search_file(recpath, tsmovepath,".ts")
        else:
            recdblist.printutf8(u"ts_movepathが設定されていません。/etc/rec10.confを設定してください。")